<?php
namespace Newland\Toubiz\Sync\Neos\Domain\Filter;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Sync\Neos\Domain\Model\AbstractEntity;

/**
 * Filter interface.
 */
interface FilterInterface
{
    /**
     * Initializes possible filter options by a given array.
     *
     * @param array $config
     * @return void
     */
    public function initialize(array $config);

    /**
     * Returns true if the filter has configured left joins.
     * @return bool
     */
    public function hasLeftJoins(): bool;

    /**
     * Returns an array of configured left joins for the query.
     * The returned array must use the fieldname on which is joined as a key
     * and the tablename to which is joined as a value.
     * @return string[]
     */
    public function getLeftJoins(): array;

    /**
     * Returns true if the filter has configured inner joins.
     * @return bool
     */
    public function hasInnerJoins(): bool;

    /**
     * Returns an array of configured inner joins for the query.
     * The returned array must use the fieldname on which is joined as a key
     * and the tablename to which is joined as a value.
     * @return string[]
     */
    public function getInnerJoins(): array;

    /**
     * Returns true if the filter has configured orderings.
     * @return bool
     */
    public function hasOrderBy(): bool;

    /**
     * Returns the orderings of the query.
     * This must be an associative array using the field name as a key and either
     * `asc` or `desc` as a value.
     * @return string[]
     */
    public function getOrderBy(): array;

    /**
     * Returns true if the filter has group by constraints configured.
     * @return bool
     */
    public function hasGroupBy(): bool;

    /**
     * Returns the name of the fields by which the query should be grouped.
     * @return string[]
     */
    public function getGroupBy(): array;

    /**
     * Returns true if the filter has a configured offset.
     * @return bool
     */
    public function hasLimit(): bool;

    /**
     * Returns the limit for the query.
     * @return int
     */
    public function getLimit(): int;

    /**
     * Returns true if the filter has a configured offset.
     * @return bool
     */
    public function hasOffset(): bool;

    /**
     * Returns the offset for the query.
     * @return int
     */
    public function getOffset(): int;

    /**
     * Returns true if excludes exist.
     * @return bool
     */
    public function hasExcludes(): bool;

    /**
     * Returns the entities that should be excluded from the results.
     * @return AbstractEntity[]
     */
    public function getExcludes(): array;

    /**
     * @param string $relation
     * @param string $alias
     * @param string $direction
     * @return void
     */
    public function orderByRelation(string $relation, string $alias, string $direction);

    /**
     * Returns the relation ordering:
     * The returned array is an array of associative arrays.
     * Those associative arrays contain the following keys:
     * - `relation`
     * - `alias`
     * - `direction`
     *
     * @return array
     */
    public function getOrderByRelation(): array;
}
