<?php
namespace Newland\Toubiz\Sync\Neos\Command;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Newland\Toubiz\Api\Service\ServiceFactory;
use Newland\Toubiz\Sync\Neos\Importer\RegionImporter;

/**
 * Snow report command controller.
 *
 * Provides commands to manipulate snow report data.
 *
 * @Flow\Scope("singleton")
 */
class SnowReportCommandController extends AbstractCommandController
{
    const TYPE_SISAG = 'sisag';

    /**
     * @Flow\InjectConfiguration
     * @var array
     */
    protected $configuration;

    /**
     * Synchronize command.
     *
     * Updates local snow report database from API data source.
     *
     * @param bool $quiet
     * @return void
     * @throws \Exception
     */
    public function synchronizeCommand($quiet = false)
    {
        if (!$quiet) {
            $this->showProgressOnCommandLine();
        }

        // There is currently only one API providing snow reports.
        $configuration = $this->getConfigurationForService('Sisag/Api');
        if (!$configuration) {
            throw new \Exception('Sisag/Api service not configured!');
        }
        $this->synchronizeFromSisag($configuration);
    }

    private function synchronizeFromSisag(array $configuration)
    {
        $this->emitStart(static::TYPE_SISAG);

        $service = ServiceFactory::get('Sisag/Api');
        $service->setClientName($configuration['client']);

        $regions = $service->fetchRegions();
        foreach ($regions as $i => $region) {
            $this->emitProgress(static::TYPE_SISAG, $i);
            $importer = new RegionImporter;
            $importer->import($region);
        }

        $this->emitEnd(static::TYPE_SISAG);
    }
}
