<?php
namespace Newland\Toubiz\Sync\Neos\Command;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\PackageAdapterInterface;
use Newland\Toubiz\Api\Service\ServiceFactory;
use Neos\Flow\Annotations as Flow;
use Newland\Toubiz\Api\Service\Tportal\ApiService;
use Newland\Toubiz\Sync\Neos\Importer\PackageImporter;

class PackagesCommandController extends AbstractCommandController
{
    const TYPE_TPORTAL = 'tportal';

    /**
     * @var PackageImporter
     * @Flow\Inject()
     */
    protected $packageImporter;

    /**
     * @param bool $quiet
     */
    public function synchronizeCommand($quiet = false)
    {
        if (!$quiet) {
            $this->showProgressOnCommandLine();
        }

        $configuration = $this->getConfigurationForService('Tportal/Api');
        if ($this->hasClients($configuration)) {
            foreach ($this->getClients($configuration) as $clientConfiguration) {
                $this->synchronizePackagesFromTportal($clientConfiguration);
            }
        }
    }

    private function synchronizePackagesFromTportal(array $configuration)
    {
        $this->emitStart(static::TYPE_TPORTAL);
        $client = $configuration['client'];

        /** @var ApiService $service */
        $service = ServiceFactory::get('Tportal/Api');
        $service->setClientName($client);

        $processed = 0;
        $service->fetch('packages', function (PackageAdapterInterface $package) use ($client, &$processed) {
            $this->emitProgress(static::TYPE_TPORTAL, ++$processed);
            $this->packageImporter->setClient($client);
            $this->packageImporter->import($package);
        });

        $this->emitEnd(static::TYPE_TPORTAL);
    }
}
