<?php
namespace Newland\Toubiz\Sync\Neos\Command;

/*
 * This file is part of the "neos-common" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;

class AbstractCommandController extends \Newland\NeosCommon\Command\AbstractCommandController
{
    /**
     * @Flow\InjectConfiguration
     * @var array
     */
    protected $configuration;

    /**
     * Find configuration for given service string.
     *
     * @param string $service
     * @return array|null
     */
    protected function getConfigurationForService($service)
    {
        if (array_key_exists('services', $this->configuration)
            && array_key_exists($service, $this->configuration['services'])
        ) {
            return $this->configuration['services'][$service];
        }

        return null;
    }

    /**
     * @param mixed $configuration
     * @return bool
     */
    protected function hasClients($configuration): bool
    {
        return $this->hasArrayChild($configuration, 'clients');
    }

    /**
     * @param mixed $array
     * @param string $key
     * @return bool
     */
    protected function hasArrayChild($array, string $key): bool
    {
        return is_array($array) && array_key_exists($key, $array) &&
            is_array($array[$key]);
    }

    /**
     * @param array $configuration
     * @return mixed
     */
    protected function getClients(array $configuration)
    {
        return $configuration['clients'];
    }
}
