<?php
namespace Newland\Toubiz\Sync\Neos\Command;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\OfferAdapterInterface;
use Newland\Toubiz\Api\Service\ServiceFactory;
use Neos\Flow\Annotations as Flow;
use Newland\Toubiz\Sync\Neos\Importer\OfferImporter;

/**
 * @Flow\Scope("singleton")
 */
class OfferCommandController extends AbstractCommandController
{

    /**
     * Synchronize command.
     *
     * Updates local Offer database from API data source.
     *
     * @return void
     */
    public function synchronizeCommand()
    {
        $configuration = $this->getConfigurationForService('Tportal/Api');
        if ($this->hasClients($configuration)) {
            foreach ($this->getClients($configuration) as $clientConfiguration) {
                $this->synchronizeOffersFromTportal($clientConfiguration);
            }
        }
    }

    private function synchronizeOffersFromTportal(array $configuration)
    {
        $service = ServiceFactory::get('Tportal/Api');
        $service->setClientName($configuration['client']);

        $importer = new OfferImporter();
        $service->fetch('offers', function (OfferAdapterInterface $record) use ($importer) {
            $importer->import($record);
        });
    }
}
