<?php
namespace Newland\Toubiz\Sync\Neos\Behaviour;

/**
 * Trait that adds event emitting features to every class that uses it.
 * The class itself can use `$this->emit('name-of-event', $firstArgument, $secondArgument)`
 * in order to emit/fire an event. The `on('name-of-event', $callback)` method can be used
 * to add a listener for an event.
 */
trait EventEmitter
{

    /**
     * @var \Closure[][]
     */
    protected $eventListeners = [];

    public function on(string $event, \Closure $listener)
    {
        if (!array_key_exists($event, $this->eventListeners)) {
            $this->eventListeners[$event] = [];
        }

        $this->eventListeners[$event][] = $listener;
    }

    protected function emit(string $event, ...$payload)
    {
        if (!array_key_exists($event, $this->eventListeners)) {
            return;
        }

        foreach ($this->eventListeners[$event] as $listener) {
            $listener(...$payload);
        }
    }
}
