<?php
namespace Newland\Toubiz\Sync\Neos\Domain\Model;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Doctrine\ORM\Mapping as ORM;
use Neos\Flow\Annotations as Flow;
use Newland\Toubiz\Api\ObjectAdapter\RegionObjectAdapterInterface;

/**
 * An attribute for an article, tour, etc.
 *
 * @Flow\Entity
 */
class Attribute implements \JsonSerializable
{
    /**
     * @ORM\ManyToOne(inversedBy="attributes")
     * @var Article
     */
    protected $article;

    /**
     * @var string
     */
    protected $name = '';

    /**
     * @ORM\Column(type="array", nullable=true)
     * @var mixed
     */
    protected $data;

    /**
     * @return Article|null
     */
    public function getArticle()
    {
        return $this->article;
    }

    public function setArticle(Article $article)
    {
        $this->article = $article;
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function setName(string $name)
    {
        $this->name = $name;
    }

    public function getData()
    {
        return $this->data;
    }

    public function setData($data)
    {
        $this->data = $data;
    }

    public function jsonSerialize()
    {
        return get_object_vars($this);
    }
}
