<?php
namespace Newland\Toubiz\Sync\Neos\Domain\Filter;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

/**
 * Region filter class.
 */
class RegionFilter extends AbstractFilter
{
    /**
     * @var array
     */
    protected $originalIds = [];

    /**
     * Initializes filter options.
     *
     * @param array $config
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);
    }

    /**
     * @param array $originalIds
     * @return self
     */
    public function setOriginalIds($originalIds)
    {
        $this->originalIds = $originalIds;
        return $this;
    }

    /**
     * @return array
     */
    public function getOriginalIds()
    {
        return $this->originalIds;
    }

    /**
     * @return bool
     */
    public function hasOriginalIds()
    {
        return !empty($this->originalIds);
    }
}
