<?php
namespace Newland\Toubiz\Sync\Neos\Importer;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Newland\Toubiz\Api\ObjectAdapter\AttributeAdapterInterface;
use Newland\Toubiz\Sync\Neos\Domain\Model\Article;
use Newland\Toubiz\Sync\Neos\Domain\Model\Attribute;
use Newland\Toubiz\Sync\Neos\Domain\Repository\AttributeRepository;

/**
 * Region importer.
 *
 * @Flow\Scope("singleton")
 */
class AttributeImporter extends AbstractImporter
{
    /**
     * @var AttributeAdapterInterface
     */
    protected $data;
    /**
     * @var Article
     */
    protected $article;
    /**
     * @Flow\Inject
     * @var AttributeRepository
     */
    protected $attributeRepository;

    /**
     * @var Attribute
     */
    protected $attribute;

    /**
     * Import method.
     *
     * Persist given data by creating new objects or updating existing ones.
     *
     * @param AttributeAdapterInterface $data
     * @return Attribute
     */
    public function import($data)
    {
        $this->data = $data;

        $this->attribute = $this->attributeRepository->findOneByArticleAndName($this->article, $this->data->getName());
        $persisted = !!$this->attribute;

        if (!$this->attribute) {
            $this->attribute = new Attribute();
        }

        $this->mapSimpleValues();

        if ($persisted) {
            $this->attributeRepository->update($this->attribute);
        } else {
            $this->attributeRepository->add($this->attribute);
        }

        $this->persistenceManager->persistAll();

        return $this->attribute;
    }

    public function setArticle(Article $article)
    {
        $this->article = $article;
    }

    /**
     * Maps simple values onto the event.
     *
     * @return void
     */
    protected function mapSimpleValues()
    {
        $this->attribute->setName($this->data->getName());
        $this->attribute->setData($this->data->getData());
        $this->attribute->setArticle($this->article);
    }
}
