<?php
namespace Newland\Toubiz\Sync\Neos\Enum;

class Enum
{

    /** @var array */
    protected static $constants;

    public static function validValue($value): bool
    {
        return \in_array($value, static::values());
    }

    public static function values(): array
    {
        static::extractConstants();
        return array_values(static::$constants);
    }

    /**
     * @throws \ReflectionException
     * @return void
     */
    private static function extractConstants()
    {
        if (static::$constants) {
            return;
        }

        static::$constants = (new \ReflectionClass(static::class))->getConstants();
    }
}
