<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Tests\Unit\Importer\Mock;

use Newland\Toubiz\Api\ObjectAdapter\AddressAdapterInterface;

class AddressAdapterMock implements AddressAdapterInterface
{

    /** @var array */
    public $properties = [];

    public function __construct(array $properties)
    {
        $this->properties = $properties;
    }

    public function getTitle(): ?string
    {
        return $this->properties['title'] ?? null;
    }

    public function getFirstName(): ?string
    {
        return $this->properties['firstName'] ?? null;
    }

    public function getLastName(): ?string
    {
        return $this->properties['lastName'] ?? null;
    }

    public function getStreet(): ?string
    {
        return $this->properties['street'] ?? null;
    }

    public function getZip(): ?string
    {
        return $this->properties['zip'] ?? null;
    }

    public function getCity(): ?string
    {
        return $this->properties['city'] ?? null;
    }

    public function getCountry(): ?string
    {
        return $this->properties['country'] ?? null;
    }

    public function getPhoneNumber(): ?string
    {
        return $this->properties['phoneNumber'] ?? null;
    }

    public function getFaxNumber(): ?string
    {
        return $this->properties['faxNumber'] ?? null;
    }

    public function getEmailAddress(): ?string
    {
        return $this->properties['emailAddress'] ?? null;
    }

    public function getWebsiteAddress(): ?string
    {
        return $this->properties['websiteAddress'] ?? null;
    }

    public function getLatitude(): ?float
    {
        return $this->properties['latitude'] ?? null;
    }

    public function getLongitude(): ?float
    {
        return $this->properties['longitude'] ?? null;
    }

    public function isLookup(): bool
    {
        return $this->properties['isLookup'] ?? false;
    }

    public function getExternalId(): string
    {
        return $this->properties['externalId'] ?? '';
    }
}
