<?php
namespace Newland\Toubiz\Sync\Neos\Domain\Filter;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

/**
 * Event filter class.
 */
class EventFilter extends AbstractFilter
{
    /**
     * @var string
     */
    protected const DATE_FORMAT = 'Y-m-d';

    /**
     * @var \DateTime|null
     */
    protected $fromDate;

    /**
     * @var \DateTime|null
     */
    protected $toDate;

    /**
     * @var string|null
     */
    protected $categoryIdentifier;

    /**
     * @var bool|null
     */
    protected $highlight;

    public function initialize(array $config)
    {
        parent::initialize($config);

        if (array_key_exists('date', $config)) {
            $this->fromDate = $this->parseDate($config['date']);
        } elseif (array_key_exists('dateRange', $config)) {
            $this->fromDate = $this->parseDate($config['dateRange']['from']);
            $this->toDate = $this->parseDate($config['dateRange']['to']);
        }
        if (array_key_exists('fromDate', $config)) {
            $this->setFromDate($config['fromDate']);
        }
        if (array_key_exists('toDate', $config)) {
            $this->setToDate($config['toDate']);
        }
        if (array_key_exists('category', $config)) {
            $this->categoryIdentifier = $config['category'];
        }

        return $this;
    }

    public function getFromDate(): ?\DateTime
    {
        return $this->fromDate;
    }

    public function setFromDate(\DateTime $date): self
    {
        $this->fromDate = $date;
        return $this;
    }

    public function getToDate(): ?\DateTime
    {
        return $this->toDate;
    }

    public function setToDate(\DateTime $date): self
    {
        $this->toDate = $date;
        return $this;
    }

    public function getCategory(): ?string
    {
        return $this->categoryIdentifier;
    }

    public function getHighlight(): ?bool
    {
        return $this->highlight;
    }

    public function setHighlight(?bool $highlight): self
    {
        $this->highlight = $highlight;
        return $this;
    }

    protected function parseDate(string $date): ?\DateTime
    {
        return \DateTime::createFromFormat(self::DATE_FORMAT, $date) ?: null;
    }
}
