<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Tests\Unit\Importer\Mock;

use Newland\Toubiz\Api\ObjectAdapter\Weather\DayAdapterInterface;

class DayAdapterMock implements DayAdapterInterface
{
    public $properties = [];

    public function __construct(array $properties = [])
    {
        $this->properties = $properties;
    }

    public function getDate(): \DateTime
    {
        return $this->properties['date'] ?? new \DateTime();
    }

    public function getAllHours(): array
    {
        return $this->properties['allHours'] ?? [];
    }

    public function getMainHours(): array
    {
        return $this->properties['mainHours'] ?? [];
    }

    public function getMainHoursPadded(): array
    {
        return $this->properties['mainHoursPadded'] ?? [];
    }

    public function getMaximumTemperature(): float
    {
        return $this->properties['maximumTemperature'] ?? 60;
    }

    public function getMinimumTemperature(): float
    {
        return $this->properties['maximumTemperature'] ?? 10;
    }

    public function getSymbol(): string
    {
        return $this->properties['symbol'] ?? '';
    }

    public function hasSunshineDurationData(): bool
    {
        return $this->properties['hasSunshineDurationData'] ?? false;
    }

    public function getSunshineDuration(): int
    {
        return $this->properties['sunshineDuration'] ?? 0;
    }

    public function getExternalId(): string
    {
        return $this->properties['externalId'] ?? '';
    }
}
