<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Tests\Unit\Domain\Repository;

use Neos\Flow\Tests\FunctionalTestCase;
use Newland\Toubiz\Sync\Neos\Domain\Model\Article;
use Newland\Toubiz\Sync\Neos\Domain\Repository\ArticleRepository;
use Newland\Toubiz\Sync\Neos\Tests\Factory\ArticleFactory;

/**
 * Testing abstract repository logic on the basis of ArticleRepository.
 */
class AbstractRepositoryTest extends FunctionalTestCase
{
    protected static $testablePersistenceEnabled = true;

    /** @var ArticleFactory */
    protected $factory;

    /** @var ArticleRepository */
    protected $subject;

    public function setUp(): void
    {
        parent::setUp();
        $this->factory = new ArticleFactory($this->objectManager);
        $this->subject = $this->objectManager->get(ArticleRepository::class);
        $this->subject->setStrictLanguageHandling(false);
    }

    public function testGetsAllIdentifiers(): void
    {
        $articles = $this->factory->createMultiple(6);
        $identifiers = array_map(
            function(Article $article) {
                return $article->getPersistenceObjectIdentifier();
            },
            $articles
        );

        $fromDb = $this->subject->getAllIdentifiers();

        // Sort to ensure both arrays are sorted the same
        sort($identifiers);
        sort($fromDb);

        $this->assertEquals($identifiers, $fromDb);
    }

}
