<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Tests\Unit\ErrorHandling\Fixtures;

use Neos\Flow\Annotations as Flow;
use Doctrine\ORM\Mapping as ORM;

/**
 * @Flow\Entity()
 */
class ExampleModel
{

    /** @var float */
    public $float = 1.23;

    /** @var int */
    public $int = 42;

    /** @var string */
    public $stringWithoutLength = 'abc';

    /**
     * @var string
     * @ORM\Column(length=50)
     */
    public $stringWith50CharsLength = 'abc';

    /**
     * @var string
     * @ORM\Column(type="text")
     */
    public $text = 'abc';

    /**
     * @var int|null
     * @ORM\Column(nullable=true)
     */
    public $nullableInt = 5;

    /**
     * @var int
     * @Flow\IgnoreValidation()
     */
    public $intButNotValidated = 4;
}
