<?php declare(strict_types=1);


namespace Newland\Toubiz\Sync\Neos\Tests\Factory;


use Doctrine\Common\Collections\ArrayCollection;
use Newland\Toubiz\Sync\Neos\Domain\Model\Event;

/**
 * @method Event create(array $properties = [])
 */
class EventFactory extends AbstractFactory
{

    public function make(array $properties = [])
    {
        $event = new Event();

        $event->setOriginalId($properties['originalId'] ?? $this->faker->uuid);
        $event->setScope($properties['scope'] ?? $this->faker->numberBetween(0, 4));
        $event->setTitle($properties['title'] ?? $this->faker->title);
        $event->setDescription($properties['description'] ?? $this->faker->paragraph);
        $event->setAdditionalInformation($properties['additionalInformation'] ?? $this->faker->paragraph);
        $event->setAdditionalSearchString($properties['additionalSearchString'] ?? $this->faker->paragraph);
        $event->setAdmission($properties['admission'] ?? $this->faker->paragraph);
        $event->setIsHighlight($properties['isHighlight'] ?? $this->faker->boolean);
        $event->setIsTipp($properties['isTipp'] ?? $this->faker->boolean);
        $event->setBeginsAt($properties['beginsAt'] ?? $this->faker->dateTime);
        $event->setEndsAt($properties['endsAt'] ?? $this->faker->dateTime);
        $event->setTicketUri($properties['ticketUri'] ?? $this->faker->url);
        $event->setTicketContact($properties['ticketContact'] ?? $this->faker->name);
        $event->setLink($properties['link'] ?? $this->faker->url);
        $event->setUpdatedAt($properties['updatedAt'] ?? $this->faker->dateTime);
        $event->setClient($properties['client'] ?? null);
        $event->setLanguageGrouping($properties['languageGrouping'] ?? $event->getOriginalId());

        if (array_key_exists('language', $properties)) {
            $event->setLanguage($properties['language']);
        }
        if (array_key_exists('organizer', $properties)) {
            $event->setOrganizer($properties['organizer']);
        }
        if (array_key_exists('location', $properties)) {
            $event->setLocation($properties['location']);
        }
        if (array_key_exists('eventTags', $properties)) {
            $eventTags = is_array($properties['eventTags']) ? new ArrayCollection($properties['eventTags']) : $properties['eventTags'];
            $event->setEventTags($eventTags);
        }
        if (array_key_exists('eventDates', $properties)) {
            $dates = is_array($properties['eventDates']) ? new ArrayCollection($properties['eventDates']) : $properties['eventDates'];
            $event->setEventDates($dates);
        }
        if (array_key_exists('media', $properties)) {
            $media = is_array($properties['media']) ? new ArrayCollection($properties['media']) : $properties['media'];
            $event->setMedia($media);
        }
        if (array_key_exists('categories', $properties)) {
            $categories = is_array($properties['categories']) ? new ArrayCollection($properties['categories']) : $properties['categories'];
            $event->setCategories($categories);
        }
        if (array_key_exists('urlIdentifier', $properties)) {
            $event->setUrlIdentifier($properties['urlIdentifier']);
        }

        return $event;
    }
}
