<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Domain\Model;

use Doctrine\ORM\Mapping as ORM;
use Neos\Flow\Annotations as Flow;
use Newland\Toubiz\Sync\Neos\Domain\Model\Traits\PersistenceObjectIdentifier;

/**
 * @Flow\Entity()
 * @ORM\Table()
 */
class ExternalId
{
    use PersistenceObjectIdentifier;

    /** @var string */
    protected $type;

    /** @var string */
    protected $id;

    public function getType(): string
    {
        return $this->type;
    }

    public function setType(string $type): void
    {
        $this->type = $type;
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function setId(string $id): void
    {
        $this->id = $id;
    }
}
