<?php declare(strict_types=1);
namespace Newland\Toubiz\Sync\Neos\Command\Task;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\Service\ServiceResult;

class SynchronizationResult
{

    public static function fromServiceResult(ServiceResult $serviceResult, array $touched): SynchronizationResult
    {
        return new static($serviceResult->getDeleted(), $serviceResult->getAll(), $touched);
    }

    /**
     * @param string[]|null $originalIdsToDelete
     * @param string[]|null $originalIdsToRetain
     * @param string[] $touchedUuids
     */
    public function __construct(?array $originalIdsToDelete, ?array $originalIdsToRetain, array $touchedUuids)
    {
        $this->originalIdsToDelete = $originalIdsToDelete;
        $this->originalIdsToRetain = $originalIdsToRetain;
        $this->touchedUuids = $touchedUuids;
    }

    /** @var string[]|null */
    private $originalIdsToRetain;

    /** @var string[]|null */
    private $originalIdsToDelete;

    /** @var string[] */
    private $touchedUuids;

    /** @return string[]|null */
    public function getOriginalIdsToRetain(): ?array
    {
        return $this->originalIdsToRetain;
    }

    public function getOriginalIdsToDelete(): ?array
    {
        return $this->originalIdsToDelete;
    }

    public function getTouchedUuids(): array
    {
        return $this->touchedUuids;
    }
}
