<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Tests\Unit\Importer\Mock;

use Newland\Toubiz\Api\ObjectAdapter\AddressAdapterInterface;
use Newland\Toubiz\Api\ObjectAdapter\Article\ArticleWithLocationDataInterface;
use Newland\Toubiz\Api\ObjectAdapter\Article\ArticleWithStarRatings;
use Newland\Toubiz\Api\ObjectAdapter\Article\ExternalIdSelector;
use Newland\Toubiz\Api\ObjectAdapter\ArticleAdapterInterface;
use Newland\Toubiz\Api\ObjectAdapter\AttributeAdapterInterface;
use Newland\Toubiz\Api\ObjectAdapter\CategoryAdapterInterface;
use Newland\Toubiz\Api\ObjectAdapter\ExternalIdAdapterInterface;
use Newland\Toubiz\Api\ObjectAdapter\FileAdapterInterface;
use Newland\Toubiz\Api\ObjectAdapter\HasAdditionalExternalIds;
use Newland\Toubiz\Api\ObjectAdapter\MediumAdapterInterface;
use Newland\Toubiz\Api\ObjectAdapter\StarRatingAdapterInterface;

class ArticleAdapterMock implements ArticleAdapterInterface, ArticleWithStarRatings, HasAdditionalExternalIds, ArticleWithLocationDataInterface
{

    public $properties = [];

    public function __construct(array $properties)
    {
        $this->properties = $properties;
    }

    public function getMainType(): int
    {
        return $this->properties['mainType'] ?? -1;
    }

    public function getName(): string
    {
        return $this->properties['name'] ?? '';
    }

    public function getAbstract(): ?string
    {
        return $this->properties['abstract'] ?? null;
    }

    public function getDescription(): ?string
    {
        return $this->properties['description'] ?? null;
    }

    public function getMainAddress(): ?AddressAdapterInterface
    {
        return $this->properties['mainAddress'] ?? null;
    }

    public function getAddresses(): array
    {
        return $this->properties['addresses'] ?? [];
    }

    public function getCategories(): array
    {
        return $this->properties['categories'] ?? [];
    }

    public function getMedia(): array
    {
        return $this->properties['media'] ?? [];
    }

    public function getMainMedium(): ?MediumAdapterInterface
    {
        return $this->properties['mainMedium'] ?? null;
    }

    public function getFiles(): array
    {
        return $this->properties['files'] ?? [];
    }

    public function hasAttributes(): bool
    {
        return !empty($this->properties['attributes'] ?? null);
    }

    public function getAttributes(): array
    {
        return $this->properties['attributes'] ?? [];
    }

    public function getFacebookUri(): ?string
    {
        return $this->properties['facebookUri'] ?? null;
    }

    public function getTwitterUri(): ?string
    {
        return $this->properties['twitterUri'] ?? null;
    }

    public function getInstagramUri(): ?string
    {
        return $this->properties['instagramUri'] ?? null;
    }

    public function getYoutubeUri(): ?string
    {
        return $this->properties['youtubeUri'] ?? null;
    }

    public function getWikipediaUri(): ?string
    {
        return $this->properties['wikipediaUri'] ?? null;
    }

    public function getFlickrUri(): ?string
    {
        return $this->properties['flickrUri'] ?? null;
    }

    public function getSourceName(): ?string
    {
        return $this->properties['sourceName'] ?? null;
    }

    public function getAuthorName(): ?string
    {
        return $this->properties['authorName'] ?? null;
    }

    public function getBookingUris(): array
    {
        return $this->properties['bookingUris'] ?? [];
    }

    public function getDetailUri(): ?string
    {
        return $this->properties['detailUri'] ?? null;
    }

    public function getOpeningTimes(): ?string
    {
        return $this->properties['openingTimes'] ?? null;
    }

    public function getOpeningTimesFormat(): ?string
    {
        return $this->properties['openingTimesFormat'] ?? null;
    }

    public function getStarClassification(): ?int
    {
        return $this->properties['starClassification'] ?? null;
    }

    public function getAverageRating(): ?int
    {
        return $this->properties['averageRating'] ?? null;
    }

    public function getNumberOfRatings(): ?int
    {
        return $this->properties['numberOfRatings'] ?? null;
    }

    public function getLanguage(): ?string
    {
        return $this->properties['language'] ?? null;
    }

    public function getExternalId(): string
    {
        return $this->properties['externalId'] ?? '';
    }

    public function getLatitude(): ?float
    {
        return $this->properties['latitude'] ?? null;
    }

    public function getLongitude(): ?float
    {
        return $this->properties['longitude'] ?? null;
    }

    /** @return StarRatingAdapterInterface[] */
    public function getStarRatings(): array
    {
        return $this->properties['starRatings'] ?? [];
    }

    /** @return ExternalIdAdapterInterface[] */
    public function getAdditionalExternalIds(): array
    {
        return $this->properties['additionalExternalIds'] ?? [];
    }

    /** @return ExternalIdSelector[] */
    public function getCitySelectors(): array
    {
        return $this->properties['citySelectors'] ?? [];
    }

    public function getSourceSystem(): string
    {
        return $this->properties['sourceSystem'] ?? 'test';
    }
}
