<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Configuration;

use Neos\ContentRepository\Domain\Model\NodeInterface;
use Newland\Contracts\Neos\Filter\FilterRoot;

class MultiProvider implements ConfigurationProvider
{
    /** @var string */
    protected $type;

    /** @var ConfigurationProvider[] */
    protected $providers;

    /** @param ConfigurationProvider[] $providers */
    public function __construct(array $providers)
    {
        $this->providers = [];
        foreach ($providers as $provider) {
            foreach ($provider->types() as $type) {
                $this->providers[$type] = $provider;
            }
        }
    }

    /** @return string[] */
    public function types(): array
    {
        return array_keys($this->providers);
    }

    public function filter(NodeInterface $node): FilterRoot
    {
        return $this->providers[$this->type]->filter($node);
    }

    public function count(FilterRoot $filter): int
    {
        return $this->providers[$this->type]->count($filter);
    }

    public function fetch(FilterRoot $filter): array
    {
        return $this->providers[$this->type]->fetch($filter);
    }

    /** @param mixed $item */
    public function tableItems($item): array
    {
        return $this->providers[$this->type]->tableItems($item);
    }

    /**
     * @param mixed $item
     * @return ConfigurationAction[]
     */
    public function actions($item): array
    {
        return $this->providers[$this->type]->actions($item);
    }

    public function setType(string $type): void
    {
        $this->type = $type;
        $this->providers[$type]->setType($type);
    }
}
