# Toubiz sync package

Provides functionality to synchronize API data into Neos CMS.

## Configuration

### Settings
Configure available services (data sources) inside `Settings.yaml`. The following configuration demonstrates available service configurations.

```
Newland:
  Toubiz:
    Sync:
      Neos:
        services:
          'Toubiz/Legacy/Api':
            client: ''
            apiKey: ''
            organizer: ''

          'Toubiz/Legacy/Tportal':
            client: ''
            apikey: ''

          'Sisag/Api':
            client: ''
```

#### Configure weather data provider

Toubiz sync package supports 2 providers for weather data: "Meteotest" and "OpenWeatherMap".

Example configuration for "Meteotest":

```
Newland:
  Toubiz:
    Sync:
      Neos:
        dataProvider:
          weather: meteotest
        services:
          Meteotest/Api:
            apiKey: MYAPIKEY
            parameters:
              action: my_preconfigured_action
```

Example configuration for "OpenWeatherMap":

```
Newland:
  Toubiz:
    Sync:
      Neos:
        dataProvider:
          weather: openweathermap
        services:
          OpenWeatherMap/Api:
            apiKey: myapikey
            parameters:
              locations:
                Paris:
                  lat: 48.8588376
                  lon: 2.2768489
                Tokyo:
                  lat: 35.669107
                  lon: 139.6009544
                Sulzburg:
                  lat: 47.8277304
                  lon: 7.6954458
```

