<?php
namespace Newland\Toubiz\Sync\Neos\Domain\Repository;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Neos\Flow\Persistence\QueryInterface;
use Newland\Toubiz\Sync\Neos\Domain\Filter\EventFilter;

/**
 * Event repository.
 *
 * @Flow\Scope("singleton")
 */
class EventRepository extends AbstractRepository
{
    /**
     * Find events matching given filter.
     *
     * @param EventFilter $filter
     * @return QueryResultInterface
     */
    public function findByFilter(EventFilter $filter)
    {
        $query = $this->createQueryBuilder('event');
        $query->innerJoin('event.eventDates', 'eventDate');

        if ($filter->hasDateRange()) {
            $query->where('DATE(eventDate.beginsAt) <= :fromDate AND (eventDate.endsAt) >= :toDate')
                  ->setParameter('fromDate', $filter->getFromDate()->format('Y-m-d'))
                  ->setParameter('toDate', $filter->getToDate()->format('Y-m-d'));
        } elseif ($filter->hasFromDate()) {
            $query->where('DATE(eventDate.beginsAt) >= :date')
                  ->setParameter('date', $filter->getFromDate()->format('Y-m-d'));
        } elseif ($filter->hasToDate()) {
            $query->where('(eventDate.endsAt) >= :date')
                  ->setParameter('date', $filter->getToDate()->format('Y-m-d'));
        }

        if ($filter->hasCategory()) {
            $query->innerJoin('event.categories', 'category')
                  ->andWhere('category = :category')
                  ->setParameter('category', $filter->getCategory());
        }

        if ($filter->hasHighlight()) {
            $query->andWhere('event.isHighlight = :highlight')
                  ->setParameter('highlight', $filter->getHighlight());
        }

        if ($filter->hasLimit()) {
            $query->setMaxResults($filter->getLimit());
        }
        if ($filter->hasOffset()) {
            $query->setFirstResult($filter->getOffset());
        }

        return $query->getQuery()->execute();
    }
}
