<?php
namespace Newland\Toubiz\Sync\Neos\Domain\Model;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Neos\Flow\Annotations as Flow;
use Newland\Toubiz\Api\ObjectAdapter\RegionObjectAdapterInterface;

/**
 * A region.
 *
 * @Flow\Entity
 */
class Region extends AbstractEntity
{
    /**
     * @var string
     */
    protected $name;

    /**
     * @ORM\ManyToMany(
     *     targetEntity="Newland\Toubiz\Sync\Neos\Domain\Model\TransportationFacility",
     *     inversedBy="regions"
     * )
     * @ORM\JoinTable(name="newland_toubiz_sync_neos_region_transportation_facilities_join")
     * @var Collection<TransportationFacility>
     */
    protected $transportationFacilities;

    /**
     * @ORM\ManyToMany(
     *     targetEntity="Newland\Toubiz\Sync\Neos\Domain\Model\Slope",
     *     inversedBy="regions"
     * )
     * @ORM\JoinTable(name="newland_toubiz_sync_neos_region_slopes_join")
     * @var Collection<Slope>
     */
    protected $slopes;

    /**
     * @ORM\Column(type="array", nullable=true)
     * @var array
     */
    protected $attributes;

    /**
     * @ORM\Column(nullable=true)
     * @var \DateTime
     */
    protected $updatedAt;

    /**
     * Class constructor.
     *
     * This constructor is called before hydration and dependency
     * injection is happening.
     *
     * @return void
     */
    public function __construct()
    {
        $this->slopes = new ArrayCollection;
        $this->transportationFacilities = new ArrayCollection;
    }

    /**
     * @param Collection $facilities
     * @return void
     */
    public function setTransportationFacilities(Collection $facilities)
    {
        $this->transportationFacilities = $facilities;
    }

    /**
     * @return Collection
     */
    public function getTransportationFacilities()
    {
        return $this->transportationFacilities;
    }

    /**
     * @param Collection $facilities
     * @return void
     */
    public function setSlopes(Collection $slopes)
    {
        $this->slopes = $slopes;
    }

    /**
     * @return Collection
     */
    public function getSlopes()
    {
        return $this->slopes;
    }

    /**
     * @param string $name
     * @return void
     */
    public function setName($name)
    {
        $this->name = $name;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param array $attributes
     * @return void
     */
    public function setAttributes(array $attributes)
    {
        $this->attributes = $attributes;
    }

    /**
     * @return array
     */
    public function getAttributes()
    {
        return $this->attributes;
    }

    /**
     * @param \DateTime $updatedAt
     * @return void
     */
    public function setUpdatedAt($updatedAt)
    {
        $this->updatedAt = $updatedAt;
    }

    /**
     * @return \DateTime
     */
    public function getUpdatedAt()
    {
        return $this->updatedAt;
    }
}
