<?php
namespace Newland\Toubiz\Sync\Neos\Domain\Model;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Doctrine\ORM\Mapping as ORM;

/**
 * An address.
 *
 * @Flow\Entity
 */
class Address extends AbstractEntity
{
    /**
     * @ORM\ManyToMany(targetEntity="\Newland\Toubiz\Sync\Neos\Domain\Model\Article", mappedBy="addresses", fetch="LAZY")
     * @var Collection
     */
    protected $articles;

    /**
     * @ORM\Column(nullable=true)
     * @var string
     */
    protected $name;

    /**
     * @ORM\Column(nullable=true)
     * @var string
     */
    protected $firstName;

    /**
     * @ORM\Column(nullable=true)
     * @var string
     */
    protected $lastName;

    /**
     * @ORM\Column(nullable=true)
     * @var string
     */
    protected $street;

    /**
     * @ORM\Column(nullable=true)
     * @var string
     */
    protected $zip;

    /**
     * @ORM\Column(nullable=true)
     * @var string
     */
    protected $city;

    /**
     * @ORM\Column(nullable=true)
     * @var string
     */
    protected $phoneNumber;

    /**
     * @ORM\Column(nullable=true)
     * @var string
     */
    protected $emailAddress;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @var string
     */
    protected $websiteAddress;

    /**
     * @var string $name
     * @return void
     */
    public function setName($name)
    {
        $this->name = $name;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @var string $firstName
     * @return void
     */
    public function setFirstName($firstName)
    {
        $this->firstName = $firstName;
    }

    /**
     * @return string
     */
    public function getFirstName()
    {
        return $this->firstName;
    }

    /**
     * @var string $lastName
     * @return void
     */
    public function setLastName($lastName)
    {
        $this->lastName = $lastName;
    }

    /**
     * @return string
     */
    public function getLastName()
    {
        return $this->lastName;
    }

    /**
     * @var string $street
     * @return void
     */
    public function setStreet($street)
    {
        $this->street = $street;
    }

    /**
     * @return string
     */
    public function getStreet()
    {
        return $this->street;
    }

    /**
     * @var string $zip
     * @return void
     */
    public function setZip($zip)
    {
        $this->zip = $zip;
    }

    /**
     * @return string
     */
    public function getZip()
    {
        return $this->zip;
    }

    /**
     * @var string $city
     * @return void
     */
    public function setCity($city)
    {
        $this->city = $city;
    }

    /**
     * @return string
     */
    public function getCity()
    {
        return $this->city;
    }

    /**
     * @return string
     */
    public function getPhoneNumber()
    {
        return $this->phoneNumber;
    }

    /**
     * @param string $phoneNumber
     * @return void
     */
    public function setPhoneNumber($phoneNumber)
    {
        $this->phoneNumber = $phoneNumber;
    }

    /**
     * @return string
     */
    public function getEmailAddress()
    {
        return $this->emailAddress;
    }

    /**
     * @param string $emailAddress
     * @return void
     */
    public function setEmailAddress($emailAddress)
    {
        $this->emailAddress = $emailAddress;
    }

    /**
     * @return string
     */
    public function getWebsiteAddress()
    {
        return $this->websiteAddress;
    }

    /**
     * @param string $websiteAddress
     * @return void
     */
    public function setWebsiteAddress($websiteAddress)
    {
        $this->websiteAddress = $websiteAddress;
    }

    public function getFullAddress()
    {
        $parts = [
            $this->name,
            trim("{$this->firstName} {$this->lastName}"),
            $this->street,
            $this->zip,
            $this->city
        ];

        return implode(', ', array_filter($parts));
    }
}
