<?php
namespace Newland\Toubiz\Sync\Neos\Domain\Filter;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

/**
 * Category filter class.
 */
class CategoryFilter extends AbstractFilter implements FilterInterface
{
    /**
     * @var int
     */
    protected $articleMainType;

    /**
     * Initializes filter options.
     *
     * @param array $config
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);
    }

    /**
     * @param int $mainType
     * @return void
     */
    public function setArticleMainType($mainType)
    {
        $this->articleMainType = $mainType;
    }

    /**
     * @return int|null
     */
    public function getArticleMainType()
    {
        return $this->articleMainType;
    }

    /**
     * @return bool
     */
    public function hasArticleMainType()
    {
        return !is_null($this->articleMainType);
    }
}
