<?php
namespace Newland\Toubiz\Sync\Neos\Domain\Repository;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Neos\Flow\Persistence\QueryResultInterface;
use Newland\Toubiz\Sync\Neos\Domain\Filter\CategoryFilter;

/**
 * Category repository.
 *
 * @Flow\Scope("singleton")
 */
class CategoryRepository extends AbstractRepository
{
    /**
     * Find articles matching given filter.
     *
     * @param CategoryFilter $filter
     * @return QueryResultInterface
     */
    public function findByFilter(CategoryFilter $filter)
    {
        $query = $this->createQueryBuilder('category');
        $this->applyBasicFilter($filter, $query);

        if ($filter->hasArticleMainType()) {
            $query->innerJoin('category.articles', 'article');
            $query->andWhere(
                $query->expr()->eq('article.mainType', $filter->getArticleMainType())
            );
        }
        return $query->getQuery()->execute();
    }
}
