<?php
namespace Newland\Toubiz\Sync\Neos\Domain\Filter;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Sync\Neos\Domain\Model\Region;

/**
 * Region filter class.
 */
class RegionFilter extends AbstractFilter implements FilterInterface
{
    /**
     * @var array
     */
    protected $originalIds = [];

    /**
     * Initializes filter options.
     *
     * @param array $config
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);
    }

    /**
     * @param array $originalIds
     * @return self
     */
    public function setOriginalIds($originalIds)
    {
        $this->originalids = $originalIds;
        return $this;
    }

    /**
     * @return array
     */
    public function getOriginalIds()
    {
        return $this->originalids;
    }

    /**
     * @return bool
     */
    public function hasOriginalIds()
    {
        return !empty($this->originalIds);
    }
}
