<?php
namespace Newland\Toubiz\Sync\Neos\Command;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Newland\Toubiz\Api\Service\ServiceFactory;
use Newland\Toubiz\Sync\Neos\Importer\RegionImporter;
use Newland\Toubiz\Sync\Neos\Importer\SlopeImporter;
use Newland\Toubiz\Sync\Neos\Importer\TransportationFacilityImporter;

/**
 * Snow report command controller.
 *
 * Provides commands to manipulate snow report data.
 *
 * @Flow\Scope("singleton")
 */
class SnowReportCommandController extends AbstractCommandController
{
    /**
     * @Flow\InjectConfiguration
     * @var array
     */
    protected $configuration;

    /**
     * Synchronize command.
     *
     * Updates local snow report database from API data source.
     *
     * @return void
     */
    public function synchronizeCommand()
    {
        // There is currently only one API providing snow reports.
        $configuration = $this->getConfigurationForService('Sisag/Api');
        if (!$configuration) {
            throw new \Exception('Sisag/Api service not configured!');
        }

        $service = ServiceFactory::get('Sisag/Api');
        $service->setClientName($configuration['client']);

        $regions = $service->fetchRegions();
        foreach ($regions as $region) {
            $importer = new RegionImporter;
            $importer->import($region);
        }
    }
}
