<?php
namespace Newland\Toubiz\Sync\Neos\Command;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Neos\Flow\Cli\CommandController;

/**
 * Abstract command controller.
 *
 * Base for all command controllers.
 *
 * @Flow\Scope("singleton")
 */
abstract class AbstractCommandController extends CommandController
{
    /**
     * @Flow\InjectConfiguration
     * @var array
     */
    protected $configuration;

    /**
     * Find configuration for given service string.
     *
     * @param string $service
     * @return array|null
     */
    protected function getConfigurationForService($service)
    {
        if (array_key_exists('services', $this->configuration)
            && array_key_exists($service, $this->configuration['services'])
        ) {
            return $this->configuration['services'][$service];
        }
    }
}
