<?php
namespace Newland\Toubiz\Sync\Neos\Domain\Repository;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Doctrine\ORM\QueryBuilder;
use Neos\Flow\Annotations as Flow;
use Neos\Flow\Persistence\QueryResultInterface;
use Newland\Toubiz\Sync\Neos\Domain\Filter\RegionFilter;

/**
 * Region repository.
 *
 * @Flow\Scope("singleton")
 */
class RegionRepository extends AbstractRepository
{
    /**
     * Find events matching given filter.
     *
     * @param RegionFilter $filter
     * @return QueryResultInterface
     */
    public function findByFilter(RegionFilter $filter)
    {
        $query = $this->createQueryBuilder('region');
        $this->applyFilter($filter, $query);
        return $query->getQuery()->execute();
    }

    /**
     * Applies filter functions (from the region filter) onto
     * the given query builder.
     *
     * @param RegionFilter $filter
     * @param QueryBuilder $query
     * @return void
     */
    protected function applyFilter(RegionFilter $filter, QueryBuilder $query)
    {
        parent::applyBasicFilter($filter, $query);

        if ($filter->hasOriginalIds()) {
            $query->andWhere(
                $query->expr()->in('region.originalid', $filter->getOriginalIds())
            );
        }
    }
}
