<?php
namespace Newland\Toubiz\Sync\Neos\Domain\Filter;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Sync\Neos\Domain\Model\Region;

/**
 * Slope filter class.
 */
class SlopeFilter extends AbstractFilter implements FilterInterface
{
    /**
     * @var array<Region>
     */
    protected $regions;

    /**
     * @var array<int>
     */
    protected $types = [];

    /**
     * Initializes filter options.
     *
     * @param array $config
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);
    }

    /**
     * @param array $regions
     * @return void
     */
    public function setRegions(array $regions)
    {
        $this->regions = $regions;
    }

    /**
     * @return array
     */
    public function getRegions()
    {
        return $this->regions;
    }

    /**
     * @param mixed $regions
     * @return self
     */
    public function setRegionCollection($regions)
    {
        $this->regions = [];
        foreach ($regions as $region) {
            $this->regions[] = $region->getPersistenceObjectIdentifier();
        }
        return $this;
    }

    /**
     * @return bool
     */
    public function hasRegions()
    {
        return !empty($this->regions);
    }

    /**
     * @param array $types
     * @return void
     */
    public function setTypes($types)
    {
        $this->types = $types;
    }

    /**
     * @return array
     */
    public function getTypes()
    {
        return $this->types;
    }

    /**
     * @return bool
     */
    public function hasType()
    {
        return !empty($this->types);
    }
}
