<?php
namespace Neos\Flow\Persistence\Doctrine\Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

class Version20200723103317 extends AbstractMigration
{
    public function up(Schema $schema): void
    {
        $this->abortIf(
            $this->connection->getDatabasePlatform()->getName() != 'mysql',
            'Migration can only be executed safely on "mysql".'
        );


        $this->addSql(
            'DROP INDEX newland_toubiz_sync_neos_external_id_ident ON newland_toubiz_sync_neos_domain_model_externalid'
        );
    }

    public function down(Schema $schema): void
    {
        $this->abortIf(
            $this->connection->getDatabasePlatform()->getName() != 'mysql',
            'Migration can only be executed safely on "mysql".'
        );

        $this->addSql(
            'CREATE INDEX newland_toubiz_sync_neos_external_id_ident ON newland_toubiz_sync_neos_domain_model_externalid (type, id)'
        );
    }
}
