<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos;

use Neos\Flow\Package\FlowPackageInterface;
use Neos\Flow\Package\GenericPackage;
use Symfony\Component\Finder\Finder;

class Package extends GenericPackage implements FlowPackageInterface
{
    public function getFunctionalTestsClassFiles()
    {
        foreach ($this->fixtureDirectories() as $namespacePrefix => $directory) {
            $finder = new Finder();
            $finder
                ->files()
                ->name('*.php')
                ->in($directory);
            foreach ($finder as $file) {
                $namespace = $namespacePrefix . str_replace(
                    [ $directory, '.php', '/' ],
                    [ '', '', '\\' ],
                    (string) $file->getRealPath()
                );

                yield $namespace => $file->getRealPath();
            }
        }
    }

    private function fixtureDirectories()
    {
        $finder = new Finder();
        $finder
            ->directories()
            ->name([ 'Fixture', 'Fixtures' ])
            ->in(__DIR__ . '/../Tests/');

        foreach ($finder as $directory) {
            $namespace = str_replace(
                [ __DIR__ . '/../Tests/', '/' ],
                [ 'Newland\\Toubiz\\Sync\\Neos\\Tests\\', '\\' ],
                $directory->getPathname()
            );

            yield $namespace => $directory->getRealPath();
        }
    }

    public function getResourcesPath()
    {
        return $this->packagePath . FlowPackageInterface::DIRECTORY_RESOURCES;
    }

    public function getConfigurationPath()
    {
        return $this->packagePath . FlowPackageInterface::DIRECTORY_CONFIGURATION;
    }

    public function getFunctionalTestsPath()
    {
        return $this->packagePath . FlowPackageInterface::DIRECTORY_TESTS_FUNCTIONAL;
    }
}
