<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Tests\Unit\Importer\Mock;

use Newland\Toubiz\Api\ObjectAdapter\AddressAdapterInterface;
use Newland\Toubiz\Api\ObjectAdapter\EventAdapterInterface;

class EventAdapterMock implements EventAdapterInterface
{

    public $properties = [];

    public function __construct(array $properties)
    {
        $this->properties = $properties;
    }

    public function getName(): string
    {
        return $this->properties['name'] ?? '';
    }

    public function getDescription(): string
    {
        return $this->properties['description'] ?? '';
    }

    public function getAdditionalInformation(): string
    {
        return $this->properties['additionalInformation'] ?? '';
    }

    public function getBeginsAt(): \DateTimeInterface
    {
        return $this->properties['beginsAt'] ?? new \DateTime();
    }

    public function getEndsAt(): \DateTimeInterface
    {
        return $this->properties['endsAt'] ?? new \DateTime();
    }

    public function getAdmission(): string
    {
        return $this->properties['admission'] ?? '';
    }

    public function getIsHighlight(): bool
    {
        return $this->properties['isHighlight'] ?? false;
    }

    public function getIsTipp(): bool
    {
        return $this->properties['isTipp'] ?? false;
    }

    public function getTicketUri(): ?string
    {
        return $this->properties['ticketUri'] ?? null;
    }

    public function getTicketContact(): ?string
    {
        return $this->properties['ticketContact'] ?? null;
    }

    public function getLink(): ?string
    {
        return $this->properties['link'] ?? null;
    }

    public function getUpdatedAt(): \DateTimeInterface
    {
        return $this->properties['updatedAt'] ?? new \DateTime();
    }

    public function getCategories(): array
    {
        return $this->properties['categories'] ?? [];
    }

    public function getEventDates(): array
    {
        return $this->properties['eventDates'] ?? [];
    }

    public function getEventTags(): array
    {
        return $this->properties['eventTags'] ?? [];
    }

    public function getAttributes(): array
    {
        return $this->properties['attributes'] ?? [];
    }

    public function getMedia(): array
    {
        return $this->properties['media'] ?? [];
    }

    public function getOrganizer(): ?AddressAdapterInterface
    {
        return $this->properties['organizer'] ?? null;
    }

    public function getLocation(): ?AddressAdapterInterface
    {
        return $this->properties['location'] ?? null;
    }

    public function getSourceName(): string
    {
        return $this->properties['sourceName'] ?? '';
    }

    public function getScope(): int
    {
        return $this->properties['scope'] ?? -1;
    }

    public function getLanguage(): ?string
    {
        return $this->properties['language'] ?? null;
    }

    public function getExternalId(): string
    {
        return $this->properties['externalId'] ?? '';
    }

    public function getAdditionalSearchString(): ?string
    {
        return $this->properties['additionalSearchString'] ?? null;
    }
}
