<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Configuration;

use Neos\ContentRepository\Domain\Model\NodeInterface;
use Newland\Contracts\Neos\Filter\FilterRoot;

interface ConfigurationProvider
{

    /** @return string[] */
    public function types(): array;

    public function setType(string $type): void;

    public function filter(NodeInterface $node): FilterRoot;

    public function count(FilterRoot $filter): int;

    public function fetch(FilterRoot $filter): array;

    /**
     * Converts the given fetched item to table items: An array of primitive values displayed in the table.
     */
    public function tableItems($item): array;

    /** @return ConfigurationAction[] */
    public function actions($item): array;
}
