<?php declare(strict_types=1);
namespace Newland\Toubiz\Sync\Neos\Domain\Model\OpeningTimes;

class KitchenTime
{
    /** @var \DateTime|null */
    protected $from;

    /** @var \DateTime|null */
    protected $to;

    /** @var string */
    protected $comment;

    public function __construct(?\DateTime $from, ?\DateTime $to, string $comment)
    {
        $this->from = $from;
        $this->to = $to;
        $this->comment = $comment;
    }

    public function getFrom(): ?\DateTime
    {
        return $this->from;
    }

    public function getTo(): ?\DateTime
    {
        return $this->to;
    }

    public function getComment(): string
    {
        return $this->comment;
    }
}
