<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Domain\Model;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Neos\Flow\Annotations as Flow;
use Newland\Toubiz\Sync\Neos\Orm\Uuid\CustomUuidGeneration;
use Newland\Toubiz\Sync\Neos\Orm\Uuid\UuidGenerator;
use Newland\Toubiz\Sync\Neos\Translation\TranslatableEntity;
use Ramsey\Uuid\UuidInterface;

/**
 * @Flow\Entity()
 */
class Service extends AbstractEntity implements CustomUuidGeneration
{
    use TranslatableEntity;

    public function generateUuid(): UuidInterface
    {
        return UuidGenerator::uuidFromProperties([ $this->originalId, $this->client, $this->language ]);
    }

    /** @var string */
    protected $name;

    /**
     * @var string
     * @ORM\Column(length=20)
     */
    protected $type = '';

    /**
     * @ORM\ManyToMany(
     *     targetEntity="Newland\Toubiz\Sync\Neos\Domain\Model\Medium",
     *     inversedBy="packages",
     *     fetch="LAZY",
     *     cascade={"persist"}
     * )
     * @var Collection<Medium>
     */
    protected $media;

    /**
     * @var string[]
     * @ORM\Column(type="json")
     */
    protected $benefits = [];

    /**
     * @var float|null
     * @ORM\Column(type="float", nullable=true)
     */
    protected $minimumNights;

    /**
     * @var float|null
     * @ORM\Column(type="float", nullable=true)
     */
    protected $startingPrice;

    /**
     * ISO-4217 currency code.
     *
     * @var string|null
     * @ORM\Column(type="string", length=3, options={"fixed" = true}, nullable=true)
     */
    protected $startingPriceCurrency;

    /** @var string */
    protected $client;

    /**
     * @var integer|null
     * @ORM\Column(type="integer", nullable=true)
     */
    protected $durationMinutes;

    /**
     * @var string|null
     * @ORM\Column(type="string", nullable=true)
     */
    protected $address;

    /**
     * @var string|null
     * @ORM\Column(type="string", nullable=true)
     */
    protected $description;

    /** @var string */
    protected $detailUrl = '';

    public function __construct()
    {
        $this->media = new ArrayCollection();
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function setName(string $name): void
    {
        $this->name = $name;
    }

    public function getMedia(): Collection
    {
        return $this->media;
    }

    public function setMedia(Collection $media): void
    {
        $this->media = $media;
    }

    public function getBenefits(): array
    {
        return $this->benefits;
    }

    public function setBenefits(array $benefits): void
    {
        $this->benefits = $benefits;
    }

    public function getMinimumNights(): ?float
    {
        return $this->minimumNights;
    }

    public function setMinimumNights(?float $minimumNights): void
    {
        $this->minimumNights = $minimumNights;
    }

    public function getStartingPrice(): ?float
    {
        return $this->startingPrice;
    }

    public function setStartingPrice(?float $startingPrice): void
    {
        $this->startingPrice = $startingPrice;
    }

    public function getStartingPriceCurrency(): ?string
    {
        return $this->startingPriceCurrency;
    }

    public function setStartingPriceCurrency(?string $startingPriceCurrency): void
    {
        $this->startingPriceCurrency = $startingPriceCurrency;
    }

    public function getClient(): string
    {
        return $this->client;
    }

    public function setClient(string $client): void
    {
        $this->client = $client;
    }

    public function getDurationMinutes(): ?int
    {
        return $this->durationMinutes;
    }

    public function setDurationMinutes(?int $durationMinutes): void
    {
        $this->durationMinutes = $durationMinutes;
    }

    public function getAddress(): ?string
    {
        return $this->address;
    }

    public function setAddress(?string $address): void
    {
        $this->address = $address;
    }

    public function getDescription(): ?string
    {
        return $this->description;
    }

    public function setDescription(?string $description): void
    {
        if ($description) {
            $trimmedDescription = strlen($description) > 255 ?
                mb_strimwidth($description, 0, 255, '...') :
                $description;

            $this->description = $trimmedDescription;
        }
    }

    public function getType(): string
    {
        return $this->type;
    }

    public function setType(string $type): void
    {
        $this->type = $type;
    }

    public function getDetailUrl(): string
    {
        return $this->detailUrl;
    }

    public function setDetailUrl(string $detailUrl): void
    {
        $this->detailUrl = $detailUrl;
    }
}
