<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Domain\Model;

use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Neos\Flow\Annotations as Flow;
use Newland\Toubiz\Sync\Neos\Translation\TranslatableEntity;

/**
 * @Flow\Entity
 */
class StarClassification extends AbstractEntity
{
    use TranslatableEntity;

    /**
     * @ORM\ManyToMany(
     *     targetEntity="Newland\Toubiz\Sync\Neos\Domain\Model\Article",
     *     mappedBy="starClassifications"
     * )
     * @var Collection<Article>
     */
    protected $articles;

    /**
     * @ORM\Column(type="smallint", nullable=false)
     * @var int
     */
    protected $value = 0;

    /**
     * @ORM\Column(nullable=false)
     * @var string
     */
    protected $label = '';

    /**
     * @ORM\Column(nullable=true)
     * @var string|null
     */
    protected $badgeUrl;

    public function getValue(): int
    {
        return $this->value;
    }

    public function setValue(int $value): void
    {
        $this->value = $value;
    }

    public function getLabel(): string
    {
        return $this->label;
    }

    public function setLabel(string $label): void
    {
        $this->label = $label;
    }

    public function getBadgeUrl(): ?string
    {
        return $this->badgeUrl;
    }

    public function setBadgeUrl(?string $badgeUrl): void
    {
        $this->badgeUrl = $badgeUrl;
    }
}
