<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Tests\Unit\Domain\Repository\Mock;

use Newland\Toubiz\Sync\Neos\Domain\Model\RecordConfiguration;
use Newland\Toubiz\Sync\Neos\Domain\Model\RecordConfigurationSubject;

class TestModel implements RecordConfigurationSubject
{
    /** @var string */
    public $persistenceObjectIdentifier;

    /** @var RecordConfiguration[] */
    public $recordConfigurationsApplied = [];

    public function getPersistenceObjectIdentifier(): ?string
    {
        return $this->persistenceObjectIdentifier;
    }

    public function applyRecordConfiguration(RecordConfiguration $configuration): void
    {
        $this->recordConfigurationsApplied[] = $configuration;
    }
}
