<?php
namespace Newland\Toubiz\Sync\Neos\Domain\Model;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Doctrine\ORM\Mapping as ORM;
use Neos\Flow\Annotations as Flow;

/**
 * @Flow\Entity
 * @ORM\Table(indexes={
 *      @ORM\Index(name="newland_toubiz_sync_neos_keyvalue_identifier", columns={"identifier"})
 * })
 */
class KeyValue
{

    /** @var string */
    protected $identifier;

    /**
     * @ORM\Column(type="text")
     * @var string
     */
    protected $data;

    public function getIdentifier(): string
    {
        return $this->identifier;
    }

    public function setIdentifier(string $identifier): void
    {
        $this->identifier = $identifier;
    }

    /**
     * @return mixed
     */
    public function getValue()
    {
        return unserialize($this->data);
    }

    /**
     * @param mixed $data
     */
    public function setValue($data)
    {
        $this->data = serialize($data);
    }
}
