<?php declare(strict_types=1);


namespace Newland\Toubiz\Sync\Neos\Domain\Model\Traits;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Newland\Toubiz\Sync\Neos\Domain\Model\ExternalId;

trait HasExternalIds
{
    /**
     * @ORM\ManyToMany(targetEntity="\Newland\Toubiz\Sync\Neos\Domain\Model\ExternalId")
     * @var Collection<ExternalId>
     */
    protected $externalIds;

    public function getExternalIds(): Collection
    {
        if ($this->externalIds === null) {
            $this->externalIds = new ArrayCollection();
        }
        return $this->externalIds;
    }

    public function setExternalIds(Collection $externalIds): void
    {
        $this->externalIds = $externalIds;
    }
}
