<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Tests\Unit\Importer\Mock;

use Newland\Toubiz\Api\ObjectAdapter\MediumAdapterInterface;
use Newland\Toubiz\Api\ObjectAdapter\PackageAdapterInterface;

class PackageAdapterMock implements PackageAdapterInterface
{
    /** @var string */
    public $externalId = '';

    /** @var string */
    public $name = '';

    /** @var MediumAdapterInterface[] */
    public $media = [];

    /** @var array */
    public $benefits = [];

    /** @var int|null */
    public $minimumNights = null;

    /** @var float|null */
    public $startingPrice = null;

    /** @var string|null */
    public $startingPriceCurrency = null;

    /** @var string|null */
    public $language = null;

    /** @var string|null */
    public $detailUri = null;

    public function getExternalId(): string
    {
        return $this->externalId;
    }

    public function getName(): string
    {
        return $this->name;
    }

    /** @return MediumAdapterInterface[] */
    public function getMedia(): array
    {
        return $this->media;
    }

    public function getBenefits(): array
    {
        return $this->benefits;
    }

    public function getMinimumNights(): ?float
    {
        return $this->minimumNights;
    }

    public function getStartingPrice(): ?float
    {
        return $this->startingPrice;
    }

    public function getStartingPriceCurrency(): ?string
    {
        return $this->startingPriceCurrency;
    }

    public function getLanguage(): ?string
    {
        return $this->language;
    }

    public function getDetailUri(): ?string
    {
        return $this->detailUri;
    }
}
