<?php
namespace Newland\Toubiz\Sync\Neos\Command;

use Doctrine\ORM\QueryBuilder;
use Newland\Toubiz\Sync\Neos\Domain\Model\AbstractEntity;

interface OrphanFinder
{

    /**
     * Returns a query builder that selects orphaned elements from the repository that can
     * safely be deleted.
     *
     * @return QueryBuilder
     */
    public function orphanQuery(): QueryBuilder;

    /**
     * @param AbstractEntity $entity
     * @return void
     */
    public function remove($entity);
}
