<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Tests\Factory;

use Newland\Toubiz\Sync\Neos\Domain\Model\Offer;

/**
 * @method Offer create($properties = [])
 */
class OfferFactory extends AbstractFactory
{

    public function make(array $properties = [])
    {
        $offer = new Offer();

        $offer->setOriginalId($properties['originalId'] ?? $this->faker->uuid);
        $offer->setName($properties['name'] ?? $this->faker->name);
        $offer->setStartingPrice($properties['startingPrice'] ?? $this->faker->numberBetween(10, 100));
        $offer->setStartingPriceCurrency($properties['startingPriceCurrency'] ?? 'EUR');
        $offer->setDetailUri($properties['detailUri'] ?? $this->faker->url);
        if (array_key_exists('language', $properties)) {
            $offer->setLanguage($properties['language']);
        }

        return $offer;
    }
}
