<?php
namespace Newland\Toubiz\Sync\Neos\Enum;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\Constants\Enum;
use Newland\Toubiz\Api\ObjectAdapter\Concern\ArticleConstants;

class ArticleType extends Enum
{
    public const CITIES = 'cities';
    public const POI = 'poi';
    public const GASTRONOMY = 'gastronomy';
    public const LODGINGS = 'lodgings';
    public const TOURS = 'tours';
    public const DIRECT_MARKETERS = 'directMarketers';
    public const CONGRESS_LOCATIONS = 'congressLocations';

    /**
     * Map from article type constants to these values.
     * This is declared as static variable in order to not disturb the enum.
     */
    public static $map = [
        ArticleConstants::TYPE_CITY => self::CITIES,
        ArticleConstants::TYPE_ATTRACTION => self::POI,
        ArticleConstants::TYPE_GASTRONOMY => self::GASTRONOMY,
        ArticleConstants::TYPE_LODGING => self::LODGINGS,
        ArticleConstants::TYPE_TOUR => self::TOURS,
        ArticleConstants::TYPE_DIRECT_MARKETER => self::DIRECT_MARKETERS,
        ArticleConstants::TYPE_CONGRESS_LOCATION => self::CONGRESS_LOCATIONS,
    ];
}
