<?php declare(strict_types=1);


namespace Newland\Toubiz\Sync\Neos\Translation;

use Doctrine\ORM\Query\Expr\Andx;
use Doctrine\ORM\Query\Expr\Base;
use Doctrine\ORM\QueryBuilder;

class TranslatableQueryBuilder extends QueryBuilder
{

    /** @var Base|null */
    private $languageExpression;

    public function setLanguageExpression(?Base $languageExpression): void
    {
        $this->languageExpression = $languageExpression;
    }

    public function getDQLPart($queryPartName)
    {
        if ($queryPartName === 'where' && $this->languageExpression !== null) {
            return new Andx(
                [
                    parent::getDQLPart('where'),
                    $this->languageExpression,
                ]
            );
        }

        return parent::getDQLPart($queryPartName);
    }
}
