<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Tests\Unit\Importer\Mock;

use Newland\Toubiz\Api\ObjectAdapter\PackageAdapterInterface;

class PackageAdapterMock implements PackageAdapterInterface
{
    /** @var string */
    public $externalId = '';

    /** @var string */
    public $name = '';

    /** @var string|null */
    public $previewImage = null;

    /** @var array */
    public $benefits = [];

    /** @var int|null */
    public $minimumNights = null;

    /** @var float|null */
    public $startingPrice = null;

    /** @var string|null */
    public $startingPriceCurrency = null;

    /** @var string|null */
    public $language = null;

    /** @var string|null */
    public $detailUri = null;

    public function getExternalId(): string
    {
        return $this->externalId;
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function getPreviewImage(): ?string
    {
        return $this->previewImage;
    }

    public function getBenefits(): array
    {
        return $this->benefits;
    }

    public function getMinimumNights(): ?float
    {
        return $this->minimumNights;
    }

    public function getStartingPrice(): ?float
    {
        return $this->startingPrice;
    }

    public function getStartingPriceCurrency(): ?string
    {
        return $this->startingPriceCurrency;
    }

    public function getLanguage(): ?string
    {
        return $this->language;
    }

    public function getDetailUri(): ?string
    {
        return $this->detailUri;
    }
}
