<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Tests\Unit\Domain\Repository;

use Neos\Flow\Tests\FunctionalTestCase;
use Newland\Toubiz\Sync\Neos\Domain\Model\Category;
use Newland\Toubiz\Sync\Neos\Domain\Repository\CategoryRepository;
use Newland\Toubiz\Sync\Neos\Tests\Factory\CategoryFactory;

class CategoryRepositoryTest extends FunctionalTestCase
{
    protected static $testablePersistenceEnabled = true;

    /** @var CategoryFactory */
    protected $factory;

    /** @var CategoryRepository */
    protected $subject;

    public function setUp(): void
    {
        parent::setUp();
        $this->factory = new CategoryFactory($this->objectManager);
        $this->subject = $this->objectManager->get(CategoryRepository::class);
    }

    public function testFindingOrphansRespectsLanguages(): void
    {
        // Both should be orphans since they have no relations
        $german = $this->factory->create([ 'language' => 'de' ]);
        $english = $this->factory->create([ 'language' => 'en' ]);

        $this->subject->setLanguage('en');
        $result = $this->subject->orphanQuery()->getQuery()->execute();
        $ids = array_map(
            function(Category $category) {
                return $category->getPersistenceObjectIdentifier();
            },
            (array) $result
        );

        $this->assertNotContains($german->getPersistenceObjectIdentifier(), $ids, 'Should not have found german');
        $this->assertContains($english->getPersistenceObjectIdentifier(), $ids, 'Should have found english');
    }

}
