<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Tests\Factory;

use Newland\Toubiz\Sync\Neos\Domain\Model\Package;

class PackageFactory extends AbstractFactory
{

    public function make(array $properties = [])
    {
        $package = new Package();

        $package->setOriginalId($properties['originalId'] ?? $this->faker->uuid);
        $package->setName($properties['name'] ?? $this->faker->name);
        $package->setClient($properties['client'] ?? $this->faker->word);
        $package->setMinimumNights($properties['minimumNights'] ?? $this->faker->numberBetween(1, 5));
        $package->setStartingPrice($properties['startingPrice'] ?? $this->faker->numberBetween(10, 100));
        $package->setStartingPriceCurrency($properties['startingPriceCurrency'] ?? $this->faker->currencyCode);
        if (array_key_exists('language', $properties)) {
            $package->setLanguage($properties['language']);
        }

        return $package;
    }
}
