<?php declare(strict_types=1);
namespace Newland\Toubiz\Sync\Neos\Domain\Model;

use Neos\Flow\Annotations as Flow;
use Doctrine\ORM\Mapping as ORM;

/**
 * Represents a single benefit of a Package.
 * Examples for benefits may be
 * - Includes WiFi
 * - All inclusive
 *
 * @Flow\Entity()
 * @ORM\Table(indexes={
 *      @ORM\Index(name="newland_toubiz_sync_neos_benefit_import_ident", columns={"originalid"})
 * })
 */
class Benefit extends AbstractEntity
{
    /**
     * @var string
     */
    protected $name;

    /**
     * @var Package|null
     * @ORM\ManyToOne(targetEntity="Newland\Toubiz\Sync\Neos\Domain\Model\Package", inversedBy="benefits")
     */
    protected $package;

    public function __toString(): string
    {
        return $this->name;
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function setName(string $name): void
    {
        $this->name = $name;
    }

    public function getPackage(): ?Package
    {
        return $this->package;
    }

    public function setPackage(Package $package): void
    {
        $this->package = $package;
    }
}
